# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from .sdgraph import SDGraph
from .sdarray import SDArray
from .sdnode import SDNode
from .sdgraphobject import SDGraphObject
from .sdapiobject import SDAPIObject
from .sdtexture import SDTexture
from .sdapiobject import SDApiError
from .sdtexture import SBSPixelFormat
from .apiexception import APIException

class SDUIMgr(SDAPIObject):
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDUIMgr
        """
        super(SDUIMgr, self).__init__(APIContext, handle, *args, **kwargs)
        # Manually written code patched in by IPA begins
        # UI callbacks
        dllHandle = APIContext.mDllHandle
        self.__registerGraphViewCreatedCallback = dllHandle.registerGraphViewCreatedUICallback
        self.__registerExplorerCreatedCallback = dllHandle.registerExplorerCreatedUICallback
        self.__registerExplorerSelectionChangedCallback = dllHandle.registerExplorerSelectionChangedCallback
        self.__unregisterCallback = dllHandle.unregisterUICallback

        from .sdcallbackmap import SDCallbackMap
        self.__callbackMap = SDCallbackMap
        # Manually written code patched in by IPA ends

    def getMainWindowPtr(self) -> Optional[int]:
        """
        Get the main window pointer

        """
        outWindowPtr = ctypes.c_size_t()
        _res = self.mAPIContext.SDUIMgr_getMainWindowPtr(self.mHandle, ctypes.byref(outWindowPtr))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outWindowPtr.value

    def newMenu(self, menuTitle : str, objectName : str) -> int:
        """
        Create a new menu in the application menu bar

        :param menuTitle: The menu title
        :param objectName: The internal object name of the menu
        """
        outMenuPtr = ctypes.c_size_t()
        _res = self.mAPIContext.SDUIMgr_newMenu(self.mHandle, ctypes.create_string_buffer(menuTitle.encode('utf-8')), ctypes.create_string_buffer(objectName.encode('utf-8')), ctypes.byref(outMenuPtr))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outMenuPtr.value

    def findMenuFromObjectName(self, objectName : str) -> Optional[int]:
        """
        Return a pointer to a currently existing menu in the application menu bar

        :param objectName: The internal object name of the menu
        """
        outMenuPtr = ctypes.c_size_t()
        _res = self.mAPIContext.SDUIMgr_findMenuFromObjectName(self.mHandle, ctypes.create_string_buffer(objectName.encode('utf-8')), ctypes.byref(outMenuPtr))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outMenuPtr.value

    def deleteMenu(self, objectName : str) -> None:
        """
        Remove a menu from the application menu bar

        :param objectName: The internal object name of the menu
        """
        _res = self.mAPIContext.SDUIMgr_deleteMenu(self.mHandle, ctypes.create_string_buffer(objectName.encode('utf-8')))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def newDockWidget(self, identifier : str, title : str) -> int:
        """
        Create a new dock widget

        :param identifier: Dock internal identifier (must be unique)
        :param title: Dock title
        """
        outDockWidgetPtr = ctypes.c_size_t()
        _res = self.mAPIContext.SDUIMgr_newDockWidget(self.mHandle, ctypes.create_string_buffer(identifier.encode('utf-8')), ctypes.create_string_buffer(title.encode('utf-8')), ctypes.byref(outDockWidgetPtr))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outDockWidgetPtr.value

    def addToolbarToGraphView(self, graphViewID : int, toolbarWidgetPtr : int, toggleActionPtr : int) -> None:
        """
        Add a toolbar to a graph view

        :param graphViewID: Graph view identifier
        :param toolbarWidgetPtr: Pointer to the toolbar
        :param toggleActionPtr: Pointer to the toolbar toggle view action
        """
        _res = self.mAPIContext.SDUIMgr_addToolbarToGraphView(self.mHandle, graphViewID, toolbarWidgetPtr, toggleActionPtr)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getCurrentGraph(self) -> Optional[SDGraph]:
        """
        Get the current graph (can be None)

        """
        outSDGraph = ctypes.c_void_p()
        _res = self.mAPIContext.SDUIMgr_getCurrentGraph(self.mHandle, ctypes.byref(outSDGraph))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDGraph, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDGraph.value, ownHandle=True)

    @sd.deprecatedMethod("SDUIMgr", "This method is deprecated. Please use SDUIMgr.getCurrentGraphSelectedNodes instead")
    def getCurrentGraphSelection(self) -> Optional[SDArray[SDNode]]:
        """
        Get the selected nodes in the current graph

        """
        outSelectedNodesArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDUIMgr_getCurrentGraphSelection(self.mHandle, ctypes.byref(outSelectedNodesArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSelectedNodesArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSelectedNodesArray.value, ownHandle=True)

    def getCurrentGraphSelectedNodes(self) -> Optional[SDArray[SDNode]]:
        """
        Get the selected nodes in the current graph

        """
        outSelectedNodesArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDUIMgr_getCurrentGraphSelectedNodes(self.mHandle, ctypes.byref(outSelectedNodesArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSelectedNodesArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSelectedNodesArray.value, ownHandle=True)

    def getCurrentGraphSelectedObjects(self) -> Optional[SDArray[SDGraphObject]]:
        """
        Get the selected graph objects in the current graph

        """
        outSelectedGraphObjectsArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDUIMgr_getCurrentGraphSelectedObjects(self.mHandle, ctypes.byref(outSelectedGraphObjectsArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSelectedGraphObjectsArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSelectedGraphObjectsArray.value, ownHandle=True)

    def getGraphFromGraphViewID(self, graphViewID : int) -> Optional[SDGraph]:
        """
        Get the graph from a Graph View ID (can be None)

        :param graphViewID: The Graph View ID
        """
        outSDGraph = ctypes.c_void_p()
        _res = self.mAPIContext.SDUIMgr_getGraphFromGraphViewID(self.mHandle, graphViewID, ctypes.byref(outSDGraph))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDGraph, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDGraph.value, ownHandle=True)

    @sd.deprecatedMethod("SDUIMgr", "This method is deprecated. Please use SDUIMgr.getGraphSelectedNodesFromGraphViewID instead")
    def getCurrentGraphSelectionFromGraphViewID(self, graphViewID : int) -> Optional[SDArray[SDNode]]:
        """
        Get the selected nodes in a graph from a Graph View ID (can be None)

        :param graphViewID: The Graph View ID
        """
        outSelectedNodesArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDUIMgr_getCurrentGraphSelectionFromGraphViewID(self.mHandle, graphViewID, ctypes.byref(outSelectedNodesArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSelectedNodesArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSelectedNodesArray.value, ownHandle=True)

    def getGraphSelectedNodesFromGraphViewID(self, graphViewID : int) -> Optional[SDArray[SDNode]]:
        """
        Get the selected nodes in a graph from a Graph View ID (can be None)

        :param graphViewID: The Graph View ID
        """
        outSelectedNodesArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDUIMgr_getGraphSelectedNodesFromGraphViewID(self.mHandle, graphViewID, ctypes.byref(outSelectedNodesArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSelectedNodesArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSelectedNodesArray.value, ownHandle=True)

    def getGraphSelectedObjectsFromGraphViewID(self, graphViewID : int) -> Optional[SDArray[SDGraphObject]]:
        """
        Get the selected graph objects in the current graph

        :param graphViewID: The Graph View ID
        """
        outSelectedGraphObjectsArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDUIMgr_getGraphSelectedObjectsFromGraphViewID(self.mHandle, graphViewID, ctypes.byref(outSelectedGraphObjectsArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSelectedGraphObjectsArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSelectedGraphObjectsArray.value, ownHandle=True)

    def addActionToExplorerToolbar(self, explorerID : int, actionPtr : int) -> None:
        """
        Add an action to an explorer toolbar

        :param explorerID: Explorer identifier
        :param actionPtr: Pointer to an action
        """
        _res = self.mAPIContext.SDUIMgr_addActionToExplorerToolbar(self.mHandle, explorerID, actionPtr)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getExplorerSelection(self, explorerID : int) -> Optional[SDArray[SDAPIObject]]:
        """
        Return the currently selected items in the explorer panel

        :param explorerID: Explorer identifier
        """
        outExplorerSelection = ctypes.c_void_p()
        _res = self.mAPIContext.SDUIMgr_getExplorerSelection(self.mHandle, explorerID, ctypes.byref(outExplorerSelection))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outExplorerSelection, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outExplorerSelection.value, ownHandle=True)

    @staticmethod
    def convertSDTextureToQImage(sdTexture : SDTexture, qimagePtr : int) -> None:
        """
        Convert a SDTexture into a QImage

        :param sdTexture: The texture that will be converted
        :param qimagePtr: Shiboken pointer to the destination image
        """
        _res = sd.getContext().SDUIMgr_convertSDTextureToQImage(sdTexture.mHandle, qimagePtr)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None
    # Manually written code patched in by IPA begins
    def registerGraphViewCreatedCallback(self, callable):
        """
        Register a callback to be called when a new graph view is created
        Returns a callback ID that can be used later to unregister the callback

        :param callable: Function to call when a new graph view is created
        :type callable: Python function
        :rtype: int
        """
        functionType = ctypes.CFUNCTYPE(None, ctypes.c_size_t)
        f = functionType(callable)
        return self.__callbackMap._registerCallback(f, self.__registerGraphViewCreatedCallback)

    def registerExplorerCreatedCallback(self, callable):
        """
        Register a callback to be called when a new explorer is created
        Returns a callback ID that can be used later to unregister the callback

        :param callable: Function to call when a new explorer is created
        :type callable: Python function
        :rtype: int
        """
        functionType = ctypes.CFUNCTYPE(None, ctypes.c_size_t)
        f = functionType(callable)
        return self.__callbackMap._registerCallback(f, self.__registerExplorerCreatedCallback)

    def registerExplorerSelectionChangedCallback(self, callable):
        """
        Register a callback to be called when the explorer selection changed
        Returns a callback ID that can be used later to unregister the callback

        :param callable: Function to call when the explorer selection changed
        :type callable: Python function
        :rtype: int
        """
        functionType = ctypes.CFUNCTYPE(None, ctypes.c_size_t)
        f = functionType(callable)
        return self.__callbackMap._registerCallback(f, self.__registerExplorerSelectionChangedCallback)

    def unregisterCallback(self, callbackID):
        """
        Unregister a callback

        :param callbackID: The callback ID of the callback to unregister
        :type callbackID: int
        :rtype: None
        """
        self.__callbackMap._unregisterCallback(callbackID, self.__unregisterCallback)
    # Manually written code patched in by IPA ends

